﻿using System;
using System.Text;
using System.Xml;

namespace AHOBPR_Job_Runner.DasXml
{
    [Serializable]
    public class Client
    {
        public String Edipi { get; set; }
        public String AssigningAuthority { get; set; }

        public Client()
        {
            AssigningAuthority = "2.16.840.1.113883.3.42.10001.100001.12";//EDIPI
            
           /*
            * ICN   - 2.16.840.1.113883.4.349
            * EDIPI   2.16.840.1.113883.3.42.10001.100001.12
            * SSN   - 2.16.840.1.113883.3.184
            * */

        }

        public void GetXml(XmlWriter writer)
        {
            String prefix = "vler";

            //Client
            writer.WriteStartElement(prefix, "Client", prefix);
            writer.WriteAttributeString("s", "id", "s", "client");
            writer.WriteWhitespace("\r\n\t\t\t");
            {
                //Client Identifier:
                {
                    writer.WriteStartElement(prefix, "ClientIdentifier", prefix);
                    writer.WriteWhitespace("\r\n\t\t\t\t");
                    {
                        //Edipin
                        {
                            writer.WriteElementString("nc", "IdentificationID", "nc", Edipi);
                            writer.WriteWhitespace("\r\n\t\t\t\t");
                        }

                        //Assigning Authority:
                        {
                            writer.WriteElementString(prefix, "AssigningAuthority", prefix, AssigningAuthority);
                            writer.WriteWhitespace("\r\n\t\t\t");
                        }
                    }
                    writer.WriteEndElement();
                    writer.WriteWhitespace("\r\n\t\t\t");
                }

                //Client Status
                {
                    writer.WriteStartElement(prefix, "ClientStatus", prefix);
                    writer.WriteWhitespace("\r\n\t\t\t\t");

                    //Status Text:
                    {
                        writer.WriteElementString(prefix, "ClientStatusText", prefix, "OK");
                        writer.WriteWhitespace("\r\n\t\t\t");
                    }
                    writer.WriteEndElement();
                    writer.WriteWhitespace("\r\n\t\t\t");
                }

                //Role of Person Reference:
                {
                    writer.WriteStartElement("nc", "RoleOfPersonReference", "nc");
                    writer.WriteAttributeString("s", "ref", "s", "p1");
                    writer.WriteEndElement();
                    writer.WriteWhitespace("\r\n\t\t");
                }
            }
            writer.WriteEndElement();
            writer.WriteWhitespace("\r\n\t\t");
        }
    }
}
